from sklearn.model_selection import RandomizedSearchCV, KFold
from sklearn.naive_bayes import ComplementNB
from sklearn.metrics import accuracy_score, make_scorer
from pathlib import Path

def write_hpValues(model_Name, HP_Values,dataset):
    Path("results/%s" % dataset).mkdir(parents=True, exist_ok=True)
    Path("results/%s/%s" % (dataset,model_Name)).mkdir(parents=True, exist_ok=True)
    file_name = r'results/%s/%s/BestParam.txt' % (dataset,model_Name)
    with open(file_name, 'a+') as x_file:
        x_file.write(str(HP_Values))
        x_file.write("\n----------------------------------------------------------")
    return 0



def ComplementNB_hyperparameterTuning(X_train, Y_train,dataset):
    C_NB = ComplementNB()
    C_NB.fit(X_train, Y_train)
    HP_Values = '0'
    write_hpValues('ComplementNB', HP_Values, dataset)
    return C_NB


def ComplementNB_training_tuning(X_train,Y_train,dataset):

    CNB_Trained = ComplementNB_hyperparameterTuning(X_train,Y_train,dataset)
    CNB_Trained.fit(X_train,Y_train)
    return CNB_Trained
